﻿function createMoment(value, format) {
    var mFormat = format.toUpperCase().replace(/Y/g, 'YY');
    if (moment(value, mFormat, true).isValid())
        return moment(value, mFormat);
    if (!isNaN(value)) {
        var result = moment([1979, 11, 31]).add(Number(value), 'days');
        return result;
    }
    return moment();
}

function getDatesInRange(range, format) {
    var start = createMoment(range.start, format);
    var end = createMoment(range.end, format);
    var results = [];
    for (var m = start; m <= end; m.add(1, 'days')) {
        results.push(new Date(m.toDate()));
    }
    return results;
}

function getDisabledDates(disableDatesStringAttribute, format) {
    if (!disableDatesStringAttribute)
        return;

    var dates = [];
    var disabledDates = JSON.parse(disableDatesStringAttribute);

    if (disabledDates) {
        if (disabledDates.weekdays) {
            $.each(disabledDates.weekdays, function (i, weekday) {
                dates.push("w" + moment().day(weekday).isoWeekday());
            });
        }

        if (disabledDates.dates) {
            $.each(disabledDates.dates, function (i, date) {
                dates.push(createMoment(date, format).toDate());
            });
        }

        if (disabledDates.ranges) {
            $.each(disabledDates.ranges, function (i, range) {
                $.each(getDatesInRange(range, format), function (i, date) {
                    dates.push(date);
                });
            });
        }
    }

    return dates;
}

function getDateBoundAttribute(input, attribute) {
    var value = null;

    if (input.attr(attribute) == "0") {
        var actualDate = new Date();
        if (attribute == "data-minvalue" && input.attr("data-maxvalue") == "0") {
            value = new Date(actualDate.getFullYear(), actualDate.getMonth(), actualDate.getDate(), 00, 00, 00, 00);
        } else if (attribute == "data-maxvalue" && input.attr("data-minvalue") == "0") {
            value = new Date(actualDate.getFullYear(), actualDate.getMonth(), actualDate.getDate(), 23, 59, 59, 59);
        }
        else {
            value = actualDate;
        }
    }

    else if (input.attr(attribute) != null)
        value = new Date(input.attr(attribute));

    return value;
}


function getMinimumDateFromDateInput(input, format) {
    var now = new Date();
    format = format.toUpperCase().replace(/Y/g, 'YY').replace(/I/g, "m");

    if (areMinAndMaxAttributesSetToToday(input))
        return new Date(now.getFullYear(), now.getMonth(), now.getDate(), 00, 00, 00, 00);
    else if (isDateAttributeSetToTodayValue(input, "data-minvalue"))
        return now;
    else if (input.attr("data-minvalue"))
        return moment(input.attr("data-minvalue"), format).toDate();
    else
        return null;
}

function getMaximumDateFromDateInput(input, format) {
    var now = new Date();
    format = format.toUpperCase().replace(/Y/g, 'YY').replace(/I/g, "m");

    if (areMinAndMaxAttributesSetToToday(input))
        return new Date(now.getFullYear(), now.getMonth(), now.getDate(), 23, 59, 59, 59);
    else if (isDateAttributeSetToTodayValue(input, "data-maxvalue"))
        return now;
    else if (input.attr("data-maxvalue"))
        return moment(input.attr("data-maxvalue"), format).toDate();
    else
        return null;
}

function areMinAndMaxAttributesSetToToday(input) {
    var minIsToday = isDateAttributeSetToTodayValue(input, "data-minvalue");
    var maxIsToday = isDateAttributeSetToTodayValue(input, "data-maxvalue");
    return minIsToday && maxIsToday;
}

function isDateAttributeSetToTodayValue(input, attribute) {
    var dateAttribute = input.attr(attribute);
    return dateAttribute && dateAttribute === "0";
}